/*
    Created by Quo
*/
 


-- LOGS
-- Debug
INSERT INTO tblQuoDebug 
	(DebugID, 		x_Open, x_Close, 	Message)
VALUES ('Quo_Friends_Code',	'1',	'0',		'') ;

/*
INSERT INTO Agendas 
	(AgendaType, 				Name, 					Description)
VALUES 	('QUO_AGENDA_FRIENDS_EGYPT', 		'LOC_QUO_AGENDA_FRIENDS_EGYPT_NAME',	'LOC_QUO_AGENDA_FRIENDS_EGYPT_DESCRIPTION');

INSERT INTO AgendaTraits
	(AgendaType, 	TraitType)
VALUES 	('QUO_AGENDA_FRIENDS_EGYPT', 'QUO_TRAIT_FRIENDS_EGYPT');
*/


/*
INSERT INTO Types 
	(Type, 					Kind)
VALUES 	('QUO_TRAIT_FRIENDS_EGYPT', 		'KIND_TRAIT'),
	('QUO_TRAIT_FRIENDS_AMERICA', 'KIND_TRAIT') ,
	('QUO_TRAIT_FRIENDS_ARABIA', 'KIND_TRAIT') ,
	('QUO_TRAIT_FRIENDS_BRAZIL', 'KIND_TRAIT') ,
	('QUO_TRAIT_FRIENDS_CHINA', 'KIND_TRAIT') ,
	('QUO_TRAIT_FRIENDS_ENGLAND', 'KIND_TRAIT') ,
	('QUO_TRAIT_FRIENDS_FRANCE', 'KIND_TRAIT') ,
	('QUO_TRAIT_FRIENDS_GERMANY', 'KIND_TRAIT') ,
	('QUO_TRAIT_FRIENDS_GREECE', 'KIND_TRAIT') ,
	('QUO_TRAIT_FRIENDS_INDIA', 'KIND_TRAIT') ,
	('QUO_TRAIT_FRIENDS_JAPAN', 'KIND_TRAIT') ,
	('QUO_TRAIT_FRIENDS_KONGO', 'KIND_TRAIT') ,
	('QUO_TRAIT_FRIENDS_NORWAY', 'KIND_TRAIT') ,
	('QUO_TRAIT_FRIENDS_ROME', 'KIND_TRAIT') ,
	('QUO_TRAIT_FRIENDS_RUSSIA', 'KIND_TRAIT') ,
	('QUO_TRAIT_FRIENDS_SCYTHIA', 'KIND_TRAIT') ,
	('QUO_TRAIT_FRIENDS_SPAIN', 'KIND_TRAIT') ,
	('QUO_TRAIT_FRIENDS_SUMERIA', 'KIND_TRAIT') ;	



INSERT INTO Traits 
	(TraitType,			Name,						Description,						InternalOnly)
VALUES ('QUO_TRAIT_FRIENDS_EGYPT',	'LOC_QUO_TRAIT_FRIENDS_EGYPT_NAME',		'LOC_QUO_TRAIT_FRIENDS_EGYPT_DESCRIPTION',		0) ,
	('QUO_TRAIT_FRIENDS_AMERICA', 'LOC_QUO_TRAIT_FRIENDS_AMERICA_NAME',  'LOC_QUO_TRAIT_FRIENDS_AMERICA_DESCRIPTION',  0) ,
	('QUO_TRAIT_FRIENDS_ARABIA', 'LOC_QUO_TRAIT_FRIENDS_ARABIA_NAME',  'LOC_QUO_TRAIT_FRIENDS_ARABIA_DESCRIPTION',  0) ,
	('QUO_TRAIT_FRIENDS_BRAZIL', 'LOC_QUO_TRAIT_FRIENDS_BRAZIL_NAME',  'LOC_QUO_TRAIT_FRIENDS_BRAZIL_DESCRIPTION',  0) ,
	('QUO_TRAIT_FRIENDS_CHINA', 'LOC_QUO_TRAIT_FRIENDS_CHINA_NAME',  'LOC_QUO_TRAIT_FRIENDS_CHINA_DESCRIPTION',  0) ,
	('QUO_TRAIT_FRIENDS_ENGLAND', 'LOC_QUO_TRAIT_FRIENDS_ENGLAND_NAME',  'LOC_QUO_TRAIT_FRIENDS_ENGLAND_DESCRIPTION',  0) ,
	('QUO_TRAIT_FRIENDS_FRANCE', 'LOC_QUO_TRAIT_FRIENDS_FRANCE_NAME',  'LOC_QUO_TRAIT_FRIENDS_FRANCE_DESCRIPTION',  0) ,
	('QUO_TRAIT_FRIENDS_GERMANY', 'LOC_QUO_TRAIT_FRIENDS_GERMANY_NAME',  'LOC_QUO_TRAIT_FRIENDS_GERMANY_DESCRIPTION',  0) ,
	('QUO_TRAIT_FRIENDS_GREECE', 'LOC_QUO_TRAIT_FRIENDS_GREECE_NAME',  'LOC_QUO_TRAIT_FRIENDS_GREECE_DESCRIPTION',  0) ,
	('QUO_TRAIT_FRIENDS_INDIA', 'LOC_QUO_TRAIT_FRIENDS_INDIA_NAME',  'LOC_QUO_TRAIT_FRIENDS_INDIA_DESCRIPTION',  0) ,
	('QUO_TRAIT_FRIENDS_JAPAN', 'LOC_QUO_TRAIT_FRIENDS_JAPAN_NAME',  'LOC_QUO_TRAIT_FRIENDS_JAPAN_DESCRIPTION',  0) ,
	('QUO_TRAIT_FRIENDS_KONGO', 'LOC_QUO_TRAIT_FRIENDS_KONGO_NAME',  'LOC_QUO_TRAIT_FRIENDS_KONGO_DESCRIPTION',  0) ,
	('QUO_TRAIT_FRIENDS_NORWAY', 'LOC_QUO_TRAIT_FRIENDS_NORWAY_NAME',  'LOC_QUO_TRAIT_FRIENDS_NORWAY_DESCRIPTION',  0) ,
	('QUO_TRAIT_FRIENDS_ROME', 'LOC_QUO_TRAIT_FRIENDS_ROME_NAME',  'LOC_QUO_TRAIT_FRIENDS_ROME_DESCRIPTION',  0) ,
	('QUO_TRAIT_FRIENDS_RUSSIA', 'LOC_QUO_TRAIT_FRIENDS_RUSSIA_NAME',  'LOC_QUO_TRAIT_FRIENDS_RUSSIA_DESCRIPTION',  0) ,
	('QUO_TRAIT_FRIENDS_SCYTHIA', 'LOC_QUO_TRAIT_FRIENDS_SCYTHIA_NAME',  'LOC_QUO_TRAIT_FRIENDS_SCYTHIA_DESCRIPTION',  0) ,
	('QUO_TRAIT_FRIENDS_SPAIN', 'LOC_QUO_TRAIT_FRIENDS_SPAIN_NAME',  'LOC_QUO_TRAIT_FRIENDS_SPAIN_DESCRIPTION',  0) ,
	('QUO_TRAIT_FRIENDS_SUMERIA', 'LOC_QUO_TRAIT_FRIENDS_SUMERIA_NAME',  'LOC_QUO_TRAIT_FRIENDS_SUMERIA_DESCRIPTION',  0) ;
*/

-- dont assign these, not used any longer
/*
INSERT INTO CivilizationTraits 
	(CivilizationType, 		TraitType)
VALUES ('CIVILIZATION_EGYPT',	'QUO_TRAIT_FRIENDS_EGYPT'), 
	('CIVILIZATION_AMERICA', 'QUO_TRAIT_FRIENDS_AMERICA') ,
	('CIVILIZATION_ARABIA', 'QUO_TRAIT_FRIENDS_ARABIA') ,
	('CIVILIZATION_BRAZIL', 'QUO_TRAIT_FRIENDS_BRAZIL') ,
	('CIVILIZATION_CHINA', 'QUO_TRAIT_FRIENDS_CHINA') ,
	('CIVILIZATION_ENGLAND', 'QUO_TRAIT_FRIENDS_ENGLAND') ,
	('CIVILIZATION_FRANCE', 'QUO_TRAIT_FRIENDS_FRANCE') ,
	('CIVILIZATION_GERMANY', 'QUO_TRAIT_FRIENDS_GERMANY') ,
	('CIVILIZATION_GREECE', 'QUO_TRAIT_FRIENDS_GREECE') ,
	('CIVILIZATION_INDIA', 'QUO_TRAIT_FRIENDS_INDIA') ,
	('CIVILIZATION_JAPAN', 'QUO_TRAIT_FRIENDS_JAPAN') ,
	('CIVILIZATION_KONGO', 'QUO_TRAIT_FRIENDS_KONGO') ,
	('CIVILIZATION_NORWAY', 'QUO_TRAIT_FRIENDS_NORWAY') ,
	('CIVILIZATION_ROME', 'QUO_TRAIT_FRIENDS_ROME') ,
	('CIVILIZATION_RUSSIA', 'QUO_TRAIT_FRIENDS_RUSSIA') ,
	('CIVILIZATION_SCYTHIA', 'QUO_TRAIT_FRIENDS_SCYTHIA') ,
	('CIVILIZATION_SPAIN', 'QUO_TRAIT_FRIENDS_SPAIN') ,
	('CIVILIZATION_SUMERIA', 'QUO_TRAIT_FRIENDS_SUMERIA') ;
*/


INSERT INTO RequirementSets 
	(RequirementSetId, 		RequirementSetType)
VALUES 	('QUO_REQSET_FRIEND_NUBIA_RANGED', 	'REQUIREMENTSET_TEST_ALL') ,
('QUO_REQSET_FRIEND_INDONESIA_PLOT_GETS_FAITH', 	'REQUIREMENTSET_TEST_ALL') ;

INSERT INTO RequirementSetRequirements
	(RequirementSetId,	RequirementId)
VALUES	('QUO_REQSET_FRIEND_NUBIA_RANGED', 	'REQUIREMENT_UNIT_IS_RANGED') ,
('QUO_REQSET_FRIEND_INDONESIA_PLOT_GETS_FAITH', 	'REQUIRES_DISTRICT_IS_CITY_CENTER') ,
('QUO_REQSET_FRIEND_INDONESIA_PLOT_GETS_FAITH', 	'REQUIRES_PLOT_IS_ADJACENT_TO_COAST') ;


INSERT INTO Modifiers 
	(ModifierId, ModifierType, RunOnce, Permanent, OwnerRequirementSetId, SubjectRequirementSetId)
VALUES	('QUO_FRIENDS_EGYPT_GLOBAL', 'MODIFIER_ALL_PLAYERS_ATTACH_MODIFIER', 0, 0, NULL, 'PLAYER_DECLARED_FRIEND') ,
	('QUO_FRIENDS_AMERICA_GLOBAL', 'MODIFIER_ALL_PLAYERS_ATTACH_MODIFIER', 0, 0, NULL, 'PLAYER_DECLARED_FRIEND') ,
	('QUO_FRIENDS_ARABIA_GLOBAL', 'MODIFIER_ALL_PLAYERS_ATTACH_MODIFIER', 0, 0, NULL, 'PLAYER_DECLARED_FRIEND') ,
	('QUO_FRIENDS_ARABIA_GLOBAL_GPP', 'MODIFIER_ALL_PLAYERS_ATTACH_MODIFIER', 0, 0, NULL, 'PLAYER_DECLARED_FRIEND') ,
	('QUO_FRIENDS_BRAZIL_GLOBAL', 'MODIFIER_ALL_PLAYERS_ATTACH_MODIFIER', 0, 0, NULL, 'PLAYER_DECLARED_FRIEND') ,
	('QUO_FRIENDS_CHINA_GLOBAL', 'MODIFIER_ALL_PLAYERS_ATTACH_MODIFIER', 0, 0, NULL, 'PLAYER_DECLARED_FRIEND') ,
	('QUO_FRIENDS_ENGLAND_GLOBAL', 'MODIFIER_ALL_PLAYERS_ATTACH_MODIFIER', 0, 0, NULL, 'PLAYER_DECLARED_FRIEND') ,
	('QUO_FRIENDS_FRANCE_GLOBAL', 'MODIFIER_ALL_PLAYERS_ATTACH_MODIFIER', 0, 0, NULL, 'PLAYER_DECLARED_FRIEND') ,
	('QUO_FRIENDS_GERMANY_GLOBAL', 'MODIFIER_ALL_PLAYERS_ATTACH_MODIFIER', 0, 0, NULL, 'PLAYER_DECLARED_FRIEND') ,
	('QUO_FRIENDS_GREECE_GLOBAL', 'MODIFIER_ALL_PLAYERS_ATTACH_MODIFIER', 0, 0, NULL, 'PLAYER_DECLARED_FRIEND') ,
	('QUO_FRIENDS_INDIA_GLOBAL', 'MODIFIER_ALL_PLAYERS_ATTACH_MODIFIER', 0, 0, NULL, 'PLAYER_DECLARED_FRIEND') ,
	('QUO_FRIENDS_JAPAN_GLOBAL', 'MODIFIER_ALL_PLAYERS_ATTACH_MODIFIER', 0, 0, NULL, 'PLAYER_DECLARED_FRIEND') ,
	('QUO_FRIENDS_KONGO_GLOBAL', 'MODIFIER_ALL_PLAYERS_ATTACH_MODIFIER', 0, 0, NULL, 'PLAYER_DECLARED_FRIEND') ,
	('QUO_FRIENDS_NORWAY_GLOBAL', 'MODIFIER_ALL_PLAYERS_ATTACH_MODIFIER', 0, 0, NULL, 'PLAYER_DECLARED_FRIEND') ,
	('QUO_FRIENDS_ROME_GLOBAL', 'MODIFIER_ALL_PLAYERS_ATTACH_MODIFIER', 0, 0, NULL, 'PLAYER_DECLARED_FRIEND') ,
	('QUO_FRIENDS_RUSSIA_GLOBAL', 'MODIFIER_ALL_PLAYERS_ATTACH_MODIFIER', 0, 0, NULL, 'PLAYER_DECLARED_FRIEND') ,
	('QUO_FRIENDS_SCYTHIA_GLOBAL', 'MODIFIER_ALL_PLAYERS_ATTACH_MODIFIER', 0, 0, NULL, 'PLAYER_DECLARED_FRIEND') ,
	('QUO_FRIENDS_SPAIN_GLOBAL', 'MODIFIER_ALL_PLAYERS_ATTACH_MODIFIER', 0, 0, NULL, 'PLAYER_DECLARED_FRIEND') ,
	('QUO_FRIENDS_SUMERIA_GLOBAL', 'MODIFIER_ALL_PLAYERS_ATTACH_MODIFIER', 0, 0, NULL, 'PLAYER_DECLARED_FRIEND') ,
	
	-- expansion 1
	('QUO_FRIENDS_CREE_GLOBAL', 'MODIFIER_ALL_PLAYERS_ATTACH_MODIFIER', 0, 0, NULL, 'PLAYER_DECLARED_FRIEND') ,
	('QUO_FRIENDS_GEORGIA_GLOBAL', 'MODIFIER_ALL_PLAYERS_ATTACH_MODIFIER', 0, 0, NULL, 'PLAYER_DECLARED_FRIEND') ,
 	('QUO_FRIENDS_KOREA_GLOBAL', 'MODIFIER_ALL_PLAYERS_ATTACH_MODIFIER', 0, 0, NULL, 'PLAYER_DECLARED_FRIEND') ,
	('QUO_FRIENDS_MAPUCHE_GLOBAL', 'MODIFIER_ALL_PLAYERS_ATTACH_MODIFIER', 0, 0, NULL, 'PLAYER_DECLARED_FRIEND') ,
	('QUO_FRIENDS_MONGOLIA_GLOBAL', 'MODIFIER_ALL_PLAYERS_ATTACH_MODIFIER', 0, 0, NULL, 'PLAYER_DECLARED_FRIEND') ,
	('QUO_FRIENDS_NETHERLANDS_GLOBAL', 'MODIFIER_ALL_PLAYERS_ATTACH_MODIFIER', 0, 0, NULL, 'PLAYER_DECLARED_FRIEND') ,
	('QUO_FRIENDS_SCOTLAND_GLOBAL', 'MODIFIER_ALL_PLAYERS_ATTACH_MODIFIER', 0, 0, NULL, 'PLAYER_DECLARED_FRIEND') ,
	('QUO_FRIENDS_ZULU_GLOBAL', 'MODIFIER_ALL_PLAYERS_ATTACH_MODIFIER', 0, 0, NULL, 'PLAYER_DECLARED_FRIEND') ,
	

	--DLC
	('QUO_FRIENDS_AZTEC_GLOBAL', 'MODIFIER_ALL_PLAYERS_ATTACH_MODIFIER', 0, 0, NULL, 'PLAYER_DECLARED_FRIEND') ,
	('QUO_FRIENDS_POLAND_GLOBAL', 'MODIFIER_ALL_PLAYERS_ATTACH_MODIFIER', 0, 0, NULL, 'PLAYER_DECLARED_FRIEND') ,
 	('QUO_FRIENDS_AUSTRALIA_GLOBAL', 'MODIFIER_ALL_PLAYERS_ATTACH_MODIFIER', 0, 0, NULL, 'PLAYER_DECLARED_FRIEND') ,
	('QUO_FRIENDS_PERSIA_GLOBAL', 'MODIFIER_ALL_PLAYERS_ATTACH_MODIFIER', 0, 0, NULL, 'PLAYER_DECLARED_FRIEND') ,
	('QUO_FRIENDS_MACEDON_GLOBAL', 'MODIFIER_ALL_PLAYERS_ATTACH_MODIFIER', 0, 0, NULL, 'PLAYER_DECLARED_FRIEND') ,
	('QUO_FRIENDS_NUBIA_GLOBAL', 'MODIFIER_ALL_PLAYERS_ATTACH_MODIFIER', 0, 0, NULL, 'PLAYER_DECLARED_FRIEND') ,
	('QUO_FRIENDS_KHMER_GLOBAL', 'MODIFIER_ALL_PLAYERS_ATTACH_MODIFIER', 0, 0, NULL, 'PLAYER_DECLARED_FRIEND') ,
	('QUO_FRIENDS_INDONESIA_GLOBAL', 'MODIFIER_ALL_PLAYERS_ATTACH_MODIFIER', 0, 0, NULL, 'PLAYER_DECLARED_FRIEND') ,
	
	-- bonuses

	-- america lowers tile purchase costs. this ability was coded out in v3.0, restored in v3.1
	('QUO_FRIENDS_AMERICA_BONUS', 'MODIFIER_PLAYER_CITIES_ADJUST_PLOT_PURCHASE_COST', 0, 0, NULL, NULL) ,

	-- arabia provides +8 science in capital	
	-- changed in v3.09.3 to +5% science in the empire and free Great Prophet points
	-- in v5.0.4 made the bonus science apply only to cities with a holy site
	('QUO_FRIENDS_ARABIA_BONUS', 'MODIFIER_PLAYER_CITIES_ADJUST_CITY_YIELD_MODIFIER', 0, 0, NULL, 'CITY_HAS_HOLY_SITE') ,
	('QUO_FRIENDS_ARABIA_BONUS_GPP', 'MODIFIER_PLAYER_ADJUST_GREAT_PERSON_POINTS', 0, 0, NULL, NULL) ,

	-- brazil refunds great person points
	('QUO_FRIENDS_BRAZIL_BONUS', 'MODIFIER_PLAYER_ADJUST_GREAT_PERSON_POINTS_REFUND_PERCENT', 0, 0, NULL, NULL) ,

	-- china gives extra builder charges
	('QUO_FRIENDS_CHINA_BONUS', 'MODIFIER_PLAYER_UNITS_ADJUST_BUILDER_CHARGES', 0, 0, NULL, NULL) ,

	-- england as of v3.1 reduces cost of Harbors by 25%, changed from bonus gold in the capital
	-- ('QUO_FRIENDS_ENGLAND_BONUS', 'MODIFIER_PLAYER_CAPITAL_CITY_ADJUST_CITY_YIELD_CHANGE', 0, 0, NULL, NULL) ,
	('QUO_FRIENDS_ENGLAND_BONUS', 'MODIFIER_PLAYER_CITIES_ADJUST_DISTRICT_PRODUCTION', 0, 0, NULL, NULL) ,

	-- france gives chateaus
	('QUO_FRIENDS_FRANCE_BONUS', 'MODIFIER_PLAYER_ADJUST_VALID_IMPROVEMENT', 0, 0, NULL, NULL) ,

	-- germany in v3.1 reduces cost of industrial zones by 25%, changed from +1 production in all cities
	-- ('QUO_FRIENDS_GERMANY_BONUS', 'MODIFIER_PLAYER_CITIES_ADJUST_CITY_YIELD_CHANGE', 0, 0, NULL, NULL) ,
	('QUO_FRIENDS_GERMANY_BONUS', 'MODIFIER_PLAYER_CITIES_ADJUST_DISTRICT_PRODUCTION', 0, 0, NULL, NULL) ,

	-- greece gives additional influence per turn
	('QUO_FRIENDS_GREECE_BONUS', 	'MODIFIER_PLAYER_ADJUST_INFLUENCE_POINTS_PER_TURN', 	0, 	0, 		NULL,			NULL) ,

	-- india lets you build stepwells
	('QUO_FRIENDS_INDIA_BONUS', 	'MODIFIER_PLAYER_ADJUST_VALID_IMPROVEMENT', 	0, 		0, 		NULL, 			NULL) ,

	-- japan speeds up Encampment build speed
	('QUO_FRIENDS_JAPAN_BONUS', 'MODIFIER_PLAYER_CITIES_ADJUST_DISTRICT_PRODUCTION', 0, 0, NULL, NULL) ,

	-- +1 food in all cities
	-- in v5.0.4 added made this all cities with holy sites
	('QUO_FRIENDS_KONGO_BONUS', 'MODIFIER_PLAYER_CITIES_ADJUST_CITY_YIELD_CHANGE', 0, 0, NULL, 'CITY_HAS_HOLY_SITE') ,

	-- norway allows ships to heal
	('QUO_FRIENDS_NORWAY_BONUS', 'MODIFIER_PLAYER_UNITS_GRANT_ABILITY', 0, 0, NULL, NULL) ,

	-- rome grants the free road ability
	('QUO_FRIENDS_ROME_BONUS', 'MODIFIER_PLAYER_CITIES_GRANT_ROAD_TO_CAPITAL', 0, 0, NULL, NULL) ,

	-- russia causes border bursts on founding a city
	('QUO_FRIENDS_RUSSIA_BONUS', 'MODIFIER_PLAYER_ADJUST_CITY_TILES', 0, 0, NULL, NULL) ,

	-- scythia lets your units heal on kill
	('QUO_FRIENDS_SCYTHIA_BONUS', 'MODIFIER_PLAYER_UNITS_ADJUST_HEAL_FROM_COMBAT', 0, 0, NULL, NULL) ,

	-- spain lets you build missions
	('QUO_FRIENDS_SPAIN_BONUS', 'MODIFIER_PLAYER_ADJUST_VALID_IMPROVEMENT', 0, 0, NULL, NULL) ,

	-- sumeria allows construction of ziggurats
	('QUO_FRIENDS_SUMERIA_BONUS', 'MODIFIER_PLAYER_ADJUST_VALID_IMPROVEMENT', 0, 0, NULL, NULL) ,

	-- egypt gives extra trade routes
	-- changed for rise and fall to providing Sphinxes
	('QUO_FRIENDS_EGYPT_BONUS', 'MODIFIER_PLAYER_ADJUST_VALID_IMPROVEMENT', 0, 0, NULL, NULL) ,

	
	-- EXPANSION 1
		
	-- Korea provides bonus science in cities with a governor
	('QUO_FRIENDS_KOREA_BONUS', 'MODIFIER_PLAYER_CITIES_ADJUST_CITY_YIELD_MODIFIER', 0, 0, NULL, 'CITY_HAS_GOVERNOR') ,

	-- Cree allow you to capture tiles with Traders
	('QUO_FRIENDS_CREE_BONUS', 'MODIFIER_PLAYER_ADJUST_TRADE_ROUTE_CAPACITY', 0, 0, NULL, NULL) ,
	
	-- Georgia provides an additional influence token 
	-- Changed in v6.0.1 to increasing city defenses
	('QUO_FRIENDS_GEORGIA_BONUS', 'MODIFIER_PLAYER_CITIES_ADJUST_OUTER_DEFENSE', 0, 0, NULL, NULL) ,
	
	-- Mapuche provide a Combat Bonus against opponents in a Golden Age
	('QUO_FRIENDS_MAPUCHE_BONUS', 'MODIFIER_PLAYER_UNITS_ADJUST_COMBAT_STRENGTH', 0, 0, NULL, 'OPPONENT_IS_IN_GOLDEN_AGE_REQUIREMENTS') ,
	
	-- Mongolia provides a combat bonus to cavalry
	('QUO_FRIENDS_MONGOLIA_BONUS', 'MODIFIER_PLAYER_UNITS_ADJUST_COMBAT_STRENGTH', 0, 0, NULL, 'REQUIREMENTS_UNIT_IS_MONGOLIAN_CAVALRY') ,
	
	-- Netherlands provide loyalty from trade routes
	('QUO_FRIENDS_NETHERLANDS_BONUS', 'MODIFIER_PLAYER_ADJUST_PLAYER_IDENTITY_PER_TURN_FOR_DOMESTIC_TRADE_ROUTE_ORIGIN', 0, 0, NULL, NULL) ,
	
	-- Scotland provides a production bonus in esctatic cities
	('QUO_FRIENDS_SCOTLAND_BONUS', 'MODIFIER_PLAYER_CITIES_ADJUST_HAPPINESS_YIELD', 0, 0, NULL, NULL) ,
	
	-- Zulu allow cities with garrisons to gain +1 Loyalty per turn
	('QUO_FRIENDS_ZULU_BONUS', 'MODIFIER_PLAYER_CITIES_ADJUST_IDENTITY_PER_TURN', 0, 0, NULL, NULL) ,
	
	
	
	
	-- DLC Civs

	--  Aztec gives bonus attack strength
	('QUO_FRIENDS_AZTEC_BONUS', 'MODIFIER_PLAYER_UNITS_ADJUST_COMBAT_STRENGTH', 0, 0, NULL, NULL) ,

	-- Poland makes Encampments culture bomb 
	('QUO_FRIENDS_POLAND_BONUS', 'MODIFIER_PLAYER_ADD_CULTURE_BOMB_TRIGGER', 0, 0, NULL, NULL) ,

	-- Australia enables Outback Stations 
	('QUO_FRIENDS_AUSTRALIA_BONUS', 'MODIFIER_PLAYER_ADJUST_VALID_IMPROVEMENT', 0, 0, NULL, NULL) ,
	
	-- Macedon lowers war weariness
	('QUO_FRIENDS_MACEDON_BONUS', 'MODIFIER_PLAYER_ADJUST_WAR_WEARINESS', 0, 0, NULL, NULL) ,
	
	-- Persia allows construction of Pairidaeza
	('QUO_FRIENDS_PERSIA_BONUS', 'MODIFIER_PLAYER_ADJUST_VALID_IMPROVEMENT', 0, 0, NULL, NULL) ,
	
	-- Nubia provides Archer bonuses
	('QUO_FRIENDS_NUBIA_BONUS', 'MODIFIER_PLAYER_UNITS_ADJUST_UNIT_EXPERIENCE_MODIFIER', 0, 0, NULL, 'QUO_REQSET_FRIEND_NUBIA_RANGED') ,
	
	-- Khmer increases production toward aqueducts
	('QUO_FRIENDS_KHMER_BONUS', 'MODIFIER_PLAYER_CITIES_ADJUST_DISTRICT_PRODUCTION', 0, 0, NULL, NULL) ,

	-- Indonesia provides Faith for city centers on coast
	('QUO_FRIENDS_INDONESIA_BONUS', 'MODIFIER_PLAYER_DISTRICTS_ADJUST_YIELD_CHANGE', 0, 0, NULL, 'QUO_REQSET_FRIEND_INDONESIA_PLOT_GETS_FAITH') ;

	




INSERT INTO ModifierArguments
	(ModifierId, 			Name, 		Type, 			Value, 			Extra, 	SecondExtra)
VALUES	('QUO_FRIENDS_EGYPT_GLOBAL', 	'ModifierId', 	'ARGTYPE_IDENTITY', 	'QUO_FRIENDS_EGYPT_BONUS',			NULL, 	NULL),

	-- as of v3.1, america has changed from extra sight ability to tile discount ability
	('QUO_FRIENDS_AMERICA_GLOBAL',  'ModifierId',  'ARGTYPE_IDENTITY',  'QUO_FRIENDS_AMERICA_BONUS',   NULL,  NULL),
	('QUO_FRIENDS_ARABIA_GLOBAL',  'ModifierId',  'ARGTYPE_IDENTITY',  'QUO_FRIENDS_ARABIA_BONUS',   NULL,  NULL),
	('QUO_FRIENDS_ARABIA_GLOBAL_GPP',  'ModifierId',  'ARGTYPE_IDENTITY',  'QUO_FRIENDS_ARABIA_BONUS_GPP',   NULL,  NULL),
	('QUO_FRIENDS_BRAZIL_GLOBAL',  'ModifierId',  'ARGTYPE_IDENTITY',  'QUO_FRIENDS_BRAZIL_BONUS',   NULL,  NULL),
	('QUO_FRIENDS_CHINA_GLOBAL',  'ModifierId',  'ARGTYPE_IDENTITY',  'QUO_FRIENDS_CHINA_BONUS',   NULL,  NULL),
	('QUO_FRIENDS_ENGLAND_GLOBAL',  'ModifierId',  'ARGTYPE_IDENTITY',  'QUO_FRIENDS_ENGLAND_BONUS',   NULL,  NULL),
	('QUO_FRIENDS_FRANCE_GLOBAL',  'ModifierId',  'ARGTYPE_IDENTITY',  'QUO_FRIENDS_FRANCE_BONUS',   NULL,  NULL),
	('QUO_FRIENDS_GERMANY_GLOBAL',  'ModifierId',  'ARGTYPE_IDENTITY',  'QUO_FRIENDS_GERMANY_BONUS',   NULL,  NULL),
	('QUO_FRIENDS_GREECE_GLOBAL',  'ModifierId',  'ARGTYPE_IDENTITY',  'QUO_FRIENDS_GREECE_BONUS',   NULL,  NULL),
	('QUO_FRIENDS_INDIA_GLOBAL',  'ModifierId',  'ARGTYPE_IDENTITY',  'QUO_FRIENDS_INDIA_BONUS',   NULL,  NULL),
	('QUO_FRIENDS_JAPAN_GLOBAL',  'ModifierId',  'ARGTYPE_IDENTITY',  'QUO_FRIENDS_JAPAN_BONUS',   NULL,  NULL),
	('QUO_FRIENDS_KONGO_GLOBAL',  'ModifierId',  'ARGTYPE_IDENTITY',  'QUO_FRIENDS_KONGO_BONUS',   NULL,  NULL),
	('QUO_FRIENDS_NORWAY_GLOBAL',  'ModifierId',  'ARGTYPE_IDENTITY',  'QUO_FRIENDS_NORWAY_BONUS',   NULL,  NULL),
	('QUO_FRIENDS_ROME_GLOBAL',  'ModifierId',  'ARGTYPE_IDENTITY',  'QUO_FRIENDS_ROME_BONUS',   NULL,  NULL),
	('QUO_FRIENDS_RUSSIA_GLOBAL',  'ModifierId',  'ARGTYPE_IDENTITY',  'QUO_FRIENDS_RUSSIA_BONUS',   NULL,  NULL),
	('QUO_FRIENDS_SCYTHIA_GLOBAL',  'ModifierId',  'ARGTYPE_IDENTITY',  'QUO_FRIENDS_SCYTHIA_BONUS',   NULL,  NULL),
	('QUO_FRIENDS_SPAIN_GLOBAL',  'ModifierId',  'ARGTYPE_IDENTITY',  'QUO_FRIENDS_SPAIN_BONUS',   NULL,  NULL),
	('QUO_FRIENDS_SUMERIA_GLOBAL',  'ModifierId',  'ARGTYPE_IDENTITY',  'QUO_FRIENDS_SUMERIA_BONUS',   NULL,  NULL),

	-- expansion 1
	('QUO_FRIENDS_CREE_GLOBAL',  'ModifierId',  'ARGTYPE_IDENTITY',  'QUO_FRIENDS_CREE_BONUS',   NULL,  NULL),
	('QUO_FRIENDS_GEORGIA_GLOBAL',  'ModifierId',  'ARGTYPE_IDENTITY',  'QUO_FRIENDS_GEORGIA_BONUS',   NULL,  NULL),
	('QUO_FRIENDS_KOREA_GLOBAL',  'ModifierId',  'ARGTYPE_IDENTITY',  'QUO_FRIENDS_KOREA_BONUS',   NULL,  NULL),
	('QUO_FRIENDS_MAPUCHE_GLOBAL',  'ModifierId',  'ARGTYPE_IDENTITY',  'QUO_FRIENDS_MAPUCHE_BONUS',   NULL,  NULL),
	('QUO_FRIENDS_MONGOLIA_GLOBAL',  'ModifierId',  'ARGTYPE_IDENTITY',  'QUO_FRIENDS_MONGOLIA_BONUS',   NULL,  NULL),
	('QUO_FRIENDS_NETHERLANDS_GLOBAL',  'ModifierId',  'ARGTYPE_IDENTITY',  'QUO_FRIENDS_NETHERLANDS_BONUS',   NULL,  NULL),
	('QUO_FRIENDS_SCOTLAND_GLOBAL',  'ModifierId',  'ARGTYPE_IDENTITY',  'QUO_FRIENDS_SCOTLAND_BONUS',   NULL,  NULL),
	('QUO_FRIENDS_ZULU_GLOBAL',  'ModifierId',  'ARGTYPE_IDENTITY',  'QUO_FRIENDS_ZULU_BONUS',   NULL,  NULL),
	

	-- dlc 
	('QUO_FRIENDS_AZTEC_GLOBAL',  'ModifierId',  'ARGTYPE_IDENTITY',  'QUO_FRIENDS_AZTEC_BONUS',   NULL,  NULL),
	('QUO_FRIENDS_POLAND_GLOBAL',  'ModifierId',  'ARGTYPE_IDENTITY',  'QUO_FRIENDS_POLAND_BONUS',   NULL,  NULL),
	('QUO_FRIENDS_AUSTRALIA_GLOBAL',  'ModifierId',  'ARGTYPE_IDENTITY',  'QUO_FRIENDS_AUSTRALIA_BONUS',   NULL,  NULL),
	('QUO_FRIENDS_MACEDON_GLOBAL',  'ModifierId',  'ARGTYPE_IDENTITY',  'QUO_FRIENDS_MACEDON_BONUS',   NULL,  NULL),
	('QUO_FRIENDS_PERSIA_GLOBAL',  'ModifierId',  'ARGTYPE_IDENTITY',  'QUO_FRIENDS_PERSIA_BONUS',   NULL,  NULL),
	('QUO_FRIENDS_NUBIA_GLOBAL',  'ModifierId',  'ARGTYPE_IDENTITY',  'QUO_FRIENDS_NUBIA_BONUS',   NULL,  NULL),
	('QUO_FRIENDS_KHMER_GLOBAL',  'ModifierId',  'ARGTYPE_IDENTITY',  'QUO_FRIENDS_KHMER_BONUS',   NULL,  NULL),
	('QUO_FRIENDS_INDONESIA_GLOBAL',  'ModifierId',  'ARGTYPE_IDENTITY',  'QUO_FRIENDS_INDONESIA_BONUS',   NULL,  NULL),
	
	-- modifiers
	('QUO_FRIENDS_EGYPT_BONUS', 	'ImprovementType', 	'ARGTYPE_IDENTITY', 	'IMPROVEMENT_SPHINX',		NULL, NULL) ,

	('QUO_FRIENDS_AMERICA_BONUS', 'Amount', 	'ARGTYPE_IDENTITY', 	'-20',	NULL, 	NULL) ,

	('QUO_FRIENDS_ARABIA_BONUS', 	'Amount', 	'ARGTYPE_IDENTITY', 	'8',			NULL, 	NULL) , 
	('QUO_FRIENDS_ARABIA_BONUS', 	'YieldType', 	'ARGTYPE_IDENTITY', 	'YIELD_SCIENCE',	NULL, 	NULL) ,
	('QUO_FRIENDS_ARABIA_BONUS_GPP', 	'Amount', 	'ARGTYPE_IDENTITY', 	'2',			NULL, 	NULL) , 
	('QUO_FRIENDS_ARABIA_BONUS_GPP', 	'GreatPersonClassType', 	'ARGTYPE_IDENTITY', 	'GREAT_PERSON_CLASS_PROPHET',	NULL, 	NULL) ,
	
	('QUO_FRIENDS_BRAZIL_BONUS', 	'Amount', 	'ARGTYPE_IDENTITY', 	'10',		NULL, NULL) ,

	('QUO_FRIENDS_CHINA_BONUS', 	'Amount', 	'ARGTYPE_IDENTITY', 	'1',			NULL, 	NULL) ,

	-- ('QUO_FRIENDS_ENGLAND_BONUS', 	'Amount', 	'ARGTYPE_IDENTITY', 	'10',			NULL, 	NULL) , 
	-- ('QUO_FRIENDS_ENGLAND_BONUS', 	'YieldType', 	'ARGTYPE_IDENTITY', 	'YIELD_GOLD',	NULL, 	NULL) ,

	('QUO_FRIENDS_ENGLAND_BONUS', 	'Amount', 		'ARGTYPE_IDENTITY', 	'50',				NULL, 	NULL) ,  
	('QUO_FRIENDS_ENGLAND_BONUS', 	'DistrictType', 	'ARGTYPE_IDENTITY', 	'DISTRICT_HARBOR',	NULL, 	NULL) ,

	('QUO_FRIENDS_FRANCE_BONUS', 	'ImprovementType', 	'ARGTYPE_IDENTITY', 	'IMPROVEMENT_CHATEAU',		NULL, 	NULL) ,

	-- ('QUO_FRIENDS_GERMANY_BONUS', 	'Amount', 	'ARGTYPE_IDENTITY', 	'1',			NULL, 	NULL) , 
	-- ('QUO_FRIENDS_GERMANY_BONUS', 	'YieldType', 'ARGTYPE_IDENTITY', 	'YIELD_PRODUCTION',	NULL, 	NULL) ,

	('QUO_FRIENDS_GERMANY_BONUS', 	'Amount', 		'ARGTYPE_IDENTITY', 	'50',				NULL, 	NULL) ,  
	('QUO_FRIENDS_GERMANY_BONUS', 	'DistrictType', 	'ARGTYPE_IDENTITY', 	'DISTRICT_INDUSTRIAL_ZONE',	NULL, 	NULL) ,

	('QUO_FRIENDS_INDIA_BONUS', 	'ImprovementType', 	'ARGTYPE_IDENTITY', 	'IMPROVEMENT_STEPWELL',		NULL, 	NULL) ,

	('QUO_FRIENDS_JAPAN_BONUS', 	'Amount', 	'ARGTYPE_IDENTITY', 	'50',			NULL, 	NULL) , 
	('QUO_FRIENDS_JAPAN_BONUS', 	'DistrictType', 'ARGTYPE_IDENTITY', 	'DISTRICT_ENCAMPMENT',	NULL, 	NULL) ,

	('QUO_FRIENDS_KONGO_BONUS', 	'Amount', 	'ARGTYPE_IDENTITY', 	'2',			NULL, 	NULL) , 
	('QUO_FRIENDS_KONGO_BONUS', 	'YieldType', 	'ARGTYPE_IDENTITY', 	'YIELD_FOOD',	NULL, 	NULL) ,

	('QUO_FRIENDS_GREECE_BONUS', 	'Amount', 	'ARGTYPE_IDENTITY', 	'2',		NULL, NULL) , 

	('QUO_FRIENDS_NORWAY_BONUS', 	'AbilityType', 	'ARGTYPE_IDENTITY', 	'ABILITY_HEAL_NEUTRAL_TERRITORY',		NULL, NULL) , 
	
	('QUO_FRIENDS_SCYTHIA_BONUS', 	'Amount', 	'ARGTYPE_IDENTITY', 	'10',		NULL, 	NULL),

	('QUO_FRIENDS_SPAIN_BONUS', 	'ImprovementType', 	'ARGTYPE_IDENTITY', 	'IMPROVEMENT_MISSION',		NULL, 	NULL),

	('QUO_FRIENDS_SUMERIA_BONUS', 	'ImprovementType', 	'ARGTYPE_IDENTITY', 	'IMPROVEMENT_ZIGGURAT',		NULL, 	NULL),

	('QUO_FRIENDS_RUSSIA_BONUS', 	'Amount', 	'ARGTYPE_IDENTITY', 	'8',		NULL, 	NULL) ,

	
	
	-- expansion 1
	
	('QUO_FRIENDS_KOREA_BONUS', 	'Amount', 	'ARGTYPE_IDENTITY', 	'5',		NULL, 	NULL) ,
	('QUO_FRIENDS_KOREA_BONUS', 	'YieldType', 	'ARGTYPE_IDENTITY', 	'5',		NULL, 	NULL) ,
		
	('QUO_FRIENDS_CREE_BONUS', 	'Amount', 	'ARGTYPE_IDENTITY', 	'1',		NULL, 	NULL) ,
	
	('QUO_FRIENDS_GEORGIA_BONUS', 	'Amount', 	'ARGTYPE_IDENTITY', 	'10',		NULL, 	NULL) ,
	
	('QUO_FRIENDS_MONGOLIA_BONUS', 	'Amount', 	'ARGTYPE_IDENTITY', 	'3',		NULL, 	NULL) ,
	
	('QUO_FRIENDS_MAPUCHE_BONUS', 	'Amount', 	'ARGTYPE_IDENTITY', 	'7',		NULL, 	NULL),
	
	('QUO_FRIENDS_NETHERLANDS_BONUS', 	'Amount', 	'ARGTYPE_IDENTITY', 	'1',		NULL, 	NULL),
	
	('QUO_FRIENDS_SCOTLAND_BONUS', 	'HappinessType', 	'ARGTYPE_IDENTITY', 	'HAPPINESS_ECSTATIC',		NULL, 	NULL),
	('QUO_FRIENDS_SCOTLAND_BONUS', 	'YieldType', 	'ARGTYPE_IDENTITY', 	'YIELD_PRODUCTION',		NULL, 	NULL),
	('QUO_FRIENDS_SCOTLAND_BONUS', 	'Amount', 	'ARGTYPE_IDENTITY', 	'5',		NULL, 	NULL),
	
	
	('QUO_FRIENDS_ZULU_BONUS', 	'Amount', 	'ARGTYPE_IDENTITY', 	'1',		NULL, 	'CITY_HAS_GARRISON_UNIT_REQUIERMENT'),
	
	
	
	-- dlc
	('QUO_FRIENDS_AZTEC_BONUS', 	'Amount', 	'ARGTYPE_IDENTITY', 	'4',		NULL, 	NULL) ,

	('QUO_FRIENDS_POLAND_BONUS', 	'DistrictType', 'ARGTYPE_IDENTITY', 	'DISTRICT_ENCAMPMENT',	NULL, NULL) ,

	-- do not add Australia arguments here or risk a CTD for players without the outback station DLC, added below

	('QUO_FRIENDS_MACEDON_BONUS', 	'Amount', 	'ARGTYPE_IDENTITY', 	'-50',		NULL, 	NULL) ,
	('QUO_FRIENDS_MACEDON_BONUS', 	'Overall', 	'ARGTYPE_IDENTITY', 	'1',		NULL, 	NULL) ,

	-- changed old Persia bonus because of fear of crashes related to this ability
	-- ('QUO_FRIENDS_PERSIA_BONUS', 	'NoPenalties', 'ARGTYPE_IDENTITY', 	'1',	NULL, NULL) 
	
	-- do not add Persia arguments here or risk a CTD for players without the IMPROVEMENT_PAIRIDAEZA DLC, added below
	
	
	('QUO_FRIENDS_NUBIA_BONUS', 	'Amount', 	'ARGTYPE_IDENTITY', 	'50',		NULL, 	NULL) ,
	
	
	('QUO_FRIENDS_KHMER_BONUS', 	'Amount', 		'ARGTYPE_IDENTITY', 	'100',				NULL, 	NULL) ,  
	('QUO_FRIENDS_KHMER_BONUS', 	'DistrictType', 	'ARGTYPE_IDENTITY', 	'DISTRICT_AQUEDUCT',	NULL, 	NULL) ,
	
	
	('QUO_FRIENDS_INDONESIA_BONUS', 	'Amount', 	'ARGTYPE_IDENTITY', 	'1',					NULL, 	NULL) ,	
	('QUO_FRIENDS_INDONESIA_BONUS', 	'YieldType', 	'ARGTYPE_IDENTITY', 	'YIELD_FAITH',		NULL, 	NULL)
	;

	
	-- strings
	
	INSERT INTO ModifierStrings
	(ModifierId, 		Context, Text)
	VALUES	('QUO_FRIENDS_MAPUCHE_BONUS', 'Preview', 'QUO_LOC_FRIENDS_MAPUCHE_GLOBAL_COMBAT_DESCRIPTION') ,
	('QUO_FRIENDS_MONGOLIA_BONUS', 'Preview', 'QUO_LOC_FRIENDS_MONGOLIA_GLOBAL_COMBAT_DESCRIPTION') ;



INSERT INTO TraitModifiers
	(TraitType, 			ModifierID)
VALUES	
	('TRAIT_CIVILIZATION_FOUNDING_FATHERS', 'QUO_FRIENDS_AMERICA_GLOBAL'),
	('TRAIT_CIVILIZATION_LAST_PROPHET', 'QUO_FRIENDS_ARABIA_GLOBAL'),
	('TRAIT_CIVILIZATION_LAST_PROPHET', 'QUO_FRIENDS_ARABIA_GLOBAL_GPP'),
	('TRAIT_CIVILIZATION_AMAZON', 'QUO_FRIENDS_BRAZIL_GLOBAL'),
	('TRAIT_CIVILIZATION_DYNASTIC_CYCLE', 'QUO_FRIENDS_CHINA_GLOBAL'),
	('TRAIT_CIVILIZATION_DOUBLE_ARCHAEOLOGY_SLOTS', 'QUO_FRIENDS_ENGLAND_GLOBAL'),
	('TRAIT_CIVILIZATION_WONDER_TOURISM', 'QUO_FRIENDS_FRANCE_GLOBAL'),
	('TRAIT_CIVILIZATION_IMPERIAL_FREE_CITIES', 'QUO_FRIENDS_GERMANY_GLOBAL'),
	('TRAIT_CIVILIZATION_PLATOS_REPUBLIC', 'QUO_FRIENDS_GREECE_GLOBAL'),
	('TRAIT_CIVILIZATION_DHARMA', 'QUO_FRIENDS_INDIA_GLOBAL'),
	('TRAIT_CIVILIZATION_ADJACENT_DISTRICTS', 'QUO_FRIENDS_JAPAN_GLOBAL'),
	('TRAIT_CIVILIZATION_NKISI', 'QUO_FRIENDS_KONGO_GLOBAL'),
	('TRAIT_CIVILIZATION_EARLY_OCEAN_NAVIGATION', 'QUO_FRIENDS_NORWAY_GLOBAL'),
	('TRAIT_CIVILIZATION_ALL_ROADS_TO_ROME', 'QUO_FRIENDS_ROME_GLOBAL'),
	('TRAIT_CIVILIZATION_MOTHER_RUSSIA', 'QUO_FRIENDS_RUSSIA_GLOBAL'),
	('TRAIT_CIVILIZATION_EXTRA_LIGHT_CAVALRY', 'QUO_FRIENDS_SCYTHIA_GLOBAL'),
	('TRAIT_CIVILIZATION_TREASURE_FLEET', 'QUO_FRIENDS_SPAIN_GLOBAL'),
	('TRAIT_CIVILIZATION_FIRST_CIVILIZATION', 'QUO_FRIENDS_SUMERIA_GLOBAL') ,
	('TRAIT_CIVILIZATION_ITERU',	'QUO_FRIENDS_EGYPT_GLOBAL') ,
	
	('TRAIT_CIVILIZATION_CREE_TRADE_GAIN_TILES',	'QUO_FRIENDS_CREE_GLOBAL') ,
	('TRAIT_CIVILIZATION_THREE_KINGDOMS',	'QUO_FRIENDS_KOREA_GLOBAL') ,
	('TRAIT_CIVILIZATION_GOLDEN_AGE_QUESTS',	'QUO_FRIENDS_GEORGIA_GLOBAL') ,
	('TRAIT_CIVILIZATION_MONGOLIAN_ORTOO',	'QUO_FRIENDS_MONGOLIA_GLOBAL') ,
	('TRAIT_CIVILIZATION_MAPUCHE_TOQUI',	'QUO_FRIENDS_MAPUCHE_GLOBAL') ,
	('TRAIT_CIVILIZATION_GROTE_RIVIEREN',	'QUO_FRIENDS_NETHERLANDS_GLOBAL') ,
	('TRAIT_CIVILIZATION_SCOTTISH_ENLIGHTENMENT',	'QUO_FRIENDS_SCOTLAND_GLOBAL') ,
	('TRAIT_CIVILIZATION_ZULU_ISIBONGO',	'QUO_FRIENDS_ZULU_GLOBAL') ;
	
	
	



-- DLC Leaders
-- These need to be handled differently because the primary key must exist or we crash. Check to be sure civ exists before trying to assign
-- any modifiers to their trait.

-- Aztec DLC
INSERT INTO TraitModifiers
	(TraitType, 			ModifierID)
SELECT	'TRAIT_CIVILIZATION_LEGEND_FIVE_SUNS', 'QUO_FRIENDS_AZTEC_GLOBAL'
	FROM Civilizations WHERE Civilizations.CivilizationType = 'CIVILIZATION_AZTEC' ;

-- Aztecs need a string inserted so combat bonus shows in combat logs
INSERT INTO ModifierStrings
	(ModifierId, 		Context, Text)
VALUES	('QUO_FRIENDS_AZTEC_BONUS', 'Preview', 'QUO_LOC_FRIENDS_AZTEC_GLOBAL_COMBAT_DESCRIPTION') ;


-- Poland DLC
INSERT INTO TraitModifiers
	(TraitType, 			ModifierID)
SELECT	'TRAIT_CIVILIZATION_GOLDEN_LIBERTY', 'QUO_FRIENDS_POLAND_GLOBAL'
	FROM Civilizations WHERE Civilizations.CivilizationType = 'CIVILIZATION_POLAND' ;
 

-- Australia DLC

INSERT INTO ModifierArguments
	(ModifierId, 			Name, 		Type, 			Value, 			Extra, 	SecondExtra)
SELECT	'QUO_FRIENDS_AUSTRALIA_BONUS', 	'ImprovementType', 	'ARGTYPE_IDENTITY', 	'IMPROVEMENT_OUTBACK_STATION',		NULL, 	NULL
	FROM Civilizations WHERE Civilizations.CivilizationType = 'CIVILIZATION_AUSTRALIA' ;


INSERT INTO TraitModifiers
	(TraitType, 			ModifierID)
SELECT	'TRAIT_CIVILIZATION_LAND_DOWN_UNDER', 'QUO_FRIENDS_AUSTRALIA_GLOBAL'
	FROM Civilizations WHERE Civilizations.CivilizationType = 'CIVILIZATION_AUSTRALIA' ;

-- Macedon

INSERT INTO TraitModifiers
	(TraitType, 			ModifierID)
SELECT	'TRAIT_LEADER_TO_WORLDS_END', 'QUO_FRIENDS_MACEDON_GLOBAL'
	FROM Civilizations WHERE Civilizations.CivilizationType = 'CIVILIZATION_MACEDON' ;

	
-- Persia
INSERT INTO ModifierArguments
	(ModifierId, 			Name, 		Type, 			Value, 			Extra, 	SecondExtra)
SELECT	'QUO_FRIENDS_PERSIA_BONUS', 	'ImprovementType', 	'ARGTYPE_IDENTITY', 	'IMPROVEMENT_PAIRIDAEZA',		NULL, 	NULL
	FROM Civilizations WHERE Civilizations.CivilizationType = 'CIVILIZATION_PERSIA' ;


INSERT INTO TraitModifiers
	(TraitType, 			ModifierID)
SELECT	'TRAIT_CIVILIZATION_SATRAPIES', 'QUO_FRIENDS_PERSIA_GLOBAL'
	FROM Civilizations WHERE Civilizations.CivilizationType = 'CIVILIZATION_PERSIA' ;


-- Nubia
INSERT INTO TraitModifiers
	(TraitType, 			ModifierID)
SELECT	'TRAIT_CIVILIZATION_TA_SETI', 'QUO_FRIENDS_NUBIA_GLOBAL'
	FROM Civilizations WHERE Civilizations.CivilizationType = 'CIVILIZATION_NUBIA' ;

	
-- Khmer
INSERT INTO TraitModifiers
	(TraitType, 		ModifierId)
SELECT 'TRAIT_CIVILIZATION_KHMER_BARAYS',	'QUO_FRIENDS_KHMER_GLOBAL' 
FROM Civilizations 
WHERE Civilizations.CivilizationType='CIVILIZATION_KHMER' ;


-- Indonesia
INSERT INTO TraitModifiers
	(TraitType, 		ModifierId)
SELECT 'TRAIT_CIVILIZATION_INDONESIA_NUSANTARA',	'QUO_FRIENDS_INDONESIA_GLOBAL' 
FROM Civilizations 
WHERE Civilizations.CivilizationType='CIVILIZATION_INDONESIA' ;


	
-- ===============================================================================
-- MODDED CIVILIZATIONS
-- This system provides modded Civilizations with a Friend bonus.
-- ===============================================================================
	
-- Make a list of all the civs in the game
CREATE TABLE tblQuoUnknownFriendCivs 
	AS SELECT CivilizationType 
	FROM Civilizations 
	WHERE	StartingCivilizationLevelType='CIVILIZATION_LEVEL_FULL_CIV' ;

-- Delete from the list any civ we know already has a friend bonus
DELETE FROM tblQuoUnknownFriendCivs WHERE tblQuoUnknownFriendCivs.CivilizationType IN 
('CIVILIZATION_AMERICA',
'CIVILIZATION_ARABIA',
'CIVILIZATION_BRAZIL',
'CIVILIZATION_CHINA',
'CIVILIZATION_ENGLAND',
'CIVILIZATION_EGYPT',
'CIVILIZATION_FRANCE',
'CIVILIZATION_GERMANY',
'CIVILIZATION_GREECE',
'CIVILIZATION_INDIA',
'CIVILIZATION_JAPAN',
'CIVILIZATION_KONGO',
'CIVILIZATION_NORWAY',
'CIVILIZATION_ROME',
'CIVILIZATION_RUSSIA',
'CIVILIZATION_SCYTHIA',
'CIVILIZATION_SPAIN',
'CIVILIZATION_SUMERIA',
'CIVILIZATION_AUSTRALIA',
'CIVILIZATION_AZTEC',
'CIVILIZATION_MACEDON',
'CIVILIZATION_PERSIA',
'CIVILIZATION_NUBIA',
'CIVILIZATION_POLAND',
'CIVILIZATION_KHMER',
'CIVILIZATION_INDONESIA',
'CIVILIZATION_CREE',
'CIVILIZATION_GEORGIA',
'CIVILIZATION_KOREA',
'CIVILIZATION_MAPUCHE',
'CIVILIZATION_MONGOLIA',
'CIVILIZATION_NETHERLANDS',
'CIVILIZATION_SCOTLAND',
'CIVILIZATION_ZULU'
) ;

-- check against the MyOptions system to make sure this feature is turned on. If it is not, clear the table completely.
DELETE FROM tblQuoUnknownFriendCivs
	WHERE EXISTS (SELECT tblQuoOptions.Value FROM tblQuoOptions WHERE tblQuoOptions.OptionID='QUO_OPTION_ENABLE_FRIEND_BONUSES_FOR_MOD_CIVS' AND tblQuoOptions.Value <= 0);


-- Create friend bonuses for any civs left over
INSERT INTO Types 
	(Type, 					Kind)
VALUES ('QUO_TRAIT_FRIENDS_GENERIC', 		'KIND_TRAIT') ;


INSERT INTO Traits 
	(TraitType,			Name,						Description,						InternalOnly)
VALUES ('QUO_TRAIT_FRIENDS_GENERIC',	'LOC_QUO_TRAIT_GENERIC_FRIENDS_NAME',		'LOC_QUO_TRAIT_FRIENDS_GENERIC_DESCRIPTION',		0) ;

-- Reuse Egypt's bonus
INSERT INTO TraitModifiers
	(TraitType, 			ModifierID)
VALUES	('QUO_TRAIT_FRIENDS_GENERIC', 'QUO_FRIENDS_EGYPT_GLOBAL' );



INSERT INTO CivilizationTraits 
	(CivilizationType, 		TraitType)
SELECT tblQuoUnknownFriendCivs.CivilizationType,	'QUO_TRAIT_FRIENDS_GENERIC'
FROM tblQuoUnknownFriendCivs;




	


-- UPDATE BUG TRACKER
-- This code should go last in every file


UPDATE tblQuoDebug SET x_Close='1' WHERE DebugID='Quo_Friends_Code';


